/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.transformer.CTransformationClass;
import net.sf.eclipsecs.core.transformer.FormatterConfigWriter;
import net.sf.eclipsecs.core.transformer.FormatterConfiguration;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;

public class CheckstyleTransformer {
    private final FormatterConfiguration mFormatterSetting = new FormatterConfiguration();
    private final List<Configuration> mRules;
    private IProject mProject;
    private final List<CTransformationClass> mTransformationClasses = new ArrayList<CTransformationClass>();

    public CheckstyleTransformer(IProject project, List<Configuration> ruleList) throws CheckstylePluginException {
        this.mProject = project;
        this.mRules = ruleList;
        ArrayList<String> classnames = new ArrayList<String>();
        for (Configuration item : this.mRules) {
            classnames.add("net.sf.eclipsecs.core.transformer.ctransformerclasses." + item.getName() + "Transformer");
        }
        this.loadTransformationClasses(classnames);
    }

    private void loadTransformationClasses(List<String> classnames) throws CheckstylePluginException {
        Iterator<String> nameit = classnames.iterator();
        Iterator<Configuration> ruleit = this.mRules.iterator();
        while (nameit.hasNext() && ruleit.hasNext()) {
            String name = nameit.next();
            Configuration rule = ruleit.next();
            try {
                Class<?> transformationClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(name);
                CTransformationClass transObj = (CTransformationClass)transformationClass.newInstance();
                transObj.setRule(rule);
                this.mTransformationClasses.add(transObj);
            }
            catch (ClassNotFoundException transObj) {
            }
            catch (InstantiationException e) {
                CheckstylePluginException.rethrow(e);
            }
            catch (IllegalAccessException e) {
                CheckstylePluginException.rethrow(e);
            }
        }
    }

    public void transformRules() {
        this.loadRuleConfigurations();
        new FormatterConfigWriter(this.mProject, this.mFormatterSetting);
    }

    private void loadRuleConfigurations() {
        Iterator<CTransformationClass> it = this.mTransformationClasses.iterator();
        while (it.hasNext()) {
            FormatterConfiguration settings = it.next().transformRule();
            this.mFormatterSetting.addConfiguration(settings);
        }
    }
}

