/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.meta;

import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyType;
import net.sf.eclipsecs.core.config.meta.IOptionProvider;
import net.sf.eclipsecs.core.config.meta.RuleGroupMetadata;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public final class MetadataFactory {
    private static final Map<String, String> PUBLIC2INTERNAL_DTD_MAP = new HashMap<String, String>();
    private static Map<String, RuleGroupMetadata> sRuleGroupMetadata;
    private static Map<String, RuleMetadata> sRuleMetadata;
    private static Map<String, RuleMetadata> sAlternativeNamesMap;
    private static final String METADATA_FILENAME = "checkstyle-metadata.xml";

    static {
        PUBLIC2INTERNAL_DTD_MAP.put("-//eclipse-cs//DTD Check Metadata 1.0//EN", "/com/puppycrawl/tools/checkstyle/checkstyle-metadata_1_0.dtd");
        PUBLIC2INTERNAL_DTD_MAP.put("-//eclipse-cs//DTD Check Metadata 1.1//EN", "/com/puppycrawl/tools/checkstyle/checkstyle-metadata_1_1.dtd");
        MetadataFactory.refresh();
    }

    private MetadataFactory() {
    }

    public static List<RuleGroupMetadata> getRuleGroupMetadata() {
        ArrayList<RuleGroupMetadata> groups = new ArrayList<RuleGroupMetadata>(sRuleGroupMetadata.values());
        Collections.sort(groups, new Comparator<RuleGroupMetadata>(){

            @Override
            public int compare(RuleGroupMetadata arg0, RuleGroupMetadata arg1) {
                int prio2;
                int prio1 = arg0.getPriority();
                return prio1 < (prio2 = arg1.getPriority()) ? -1 : (prio1 == prio2 ? 0 : 1);
            }
        });
        return groups;
    }

    public static RuleGroupMetadata getRuleGroupMetadata(String name) {
        return sRuleGroupMetadata.get(name);
    }

    public static RuleMetadata getRuleMetadata(String name) {
        RuleMetadata metadata = null;
        metadata = sRuleMetadata.get(name);
        if (metadata == null) {
            metadata = sAlternativeNamesMap.get(name);
        }
        return metadata;
    }

    public static RuleMetadata createGenericMetadata(Module module) {
        String parent = null;
        try {
            Class<?> checkClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(module.getName());
            Object moduleInstance = checkClass.newInstance();
            parent = moduleInstance instanceof AbstractFileSetCheck ? "Checker" : "TreeWalker";
        }
        catch (Exception e) {
            parent = "TreeWalker";
        }
        RuleGroupMetadata otherGroup = MetadataFactory.getRuleGroupMetadata("Other");
        RuleMetadata ruleMeta = new RuleMetadata(module.getName(), module.getName(), parent, MetadataFactory.getDefaultSeverity(), false, true, true, false, otherGroup);
        module.setMetaData(ruleMeta);
        sRuleMetadata.put(ruleMeta.getInternalName(), ruleMeta);
        List<ConfigProperty> properties = module.getProperties();
        int size = properties != null ? properties.size() : 0;
        int i = 0;
        while (i < size) {
            ConfigProperty property = properties.get(i);
            ConfigPropertyMetadata meta = new ConfigPropertyMetadata(ConfigPropertyType.String, property.getName(), null, null);
            property.setMetaData(meta);
            ++i;
        }
        return ruleMeta;
    }

    public static Severity getDefaultSeverity() {
        return Severity.inherit;
    }

    public static String getStandardMessage(String messageKey, String moduleInternalName) {
        RuleMetadata rule = MetadataFactory.getRuleMetadata(moduleInternalName);
        return MetadataFactory.getStandardMessage(messageKey, rule);
    }

    public static String getStandardMessage(String messageKey, RuleMetadata rule) {
        if (messageKey == null || rule == null) {
            return null;
        }
        ArrayList<String> namesToCheck = new ArrayList<String>();
        namesToCheck.add(rule.getInternalName());
        namesToCheck.addAll(rule.getAlternativeNames());
        for (String moduleClass : namesToCheck) {
            try {
                int endIndex = moduleClass.lastIndexOf(46);
                String messages = "messages";
                if (endIndex >= 0) {
                    String packageName = moduleClass.substring(0, endIndex);
                    messages = String.valueOf(packageName) + "." + messages;
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle(messages, CheckstylePlugin.getPlatformLocale(), CheckstylePlugin.class.getClassLoader(), new UTF8Control());
                String message = resourceBundle.getString(messageKey);
                return message;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized void refresh() {
        sRuleGroupMetadata = new TreeMap<String, RuleGroupMetadata>();
        sRuleMetadata = new HashMap<String, RuleMetadata>();
        sAlternativeNamesMap = new HashMap<String, RuleMetadata>();
        try {
            MetadataFactory.doInitialization();
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log(e);
        }
    }

    private static void doInitialization() throws CheckstylePluginException {
        ClassLoader classLoader = CheckstylePlugin.getDefault().getAddonExtensionClassLoader();
        Collection<String> potentialMetadataFiles = MetadataFactory.getAllPotentialMetadataFiles(classLoader);
        for (String metadataFile : potentialMetadataFiles) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream metadataStream = classLoader.getResourceAsStream(metadataFile);){
                    if (metadataStream == null) continue;
                    ResourceBundle metadataBundle = MetadataFactory.getMetadataI18NBundle(metadataFile, classLoader);
                    MetadataFactory.parseMetadata(metadataStream, metadataBundle);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | DocumentException e) {
                CheckstyleLog.log(e, "Could not read metadata " + metadataFile);
            }
        }
    }

    private static Collection<String> getAllPotentialMetadataFiles(ClassLoader classLoader) throws CheckstylePluginException {
        ArrayList<String> potentialMetadataFiles = new ArrayList<String>();
        Set packages = null;
        try {
            packages = PackageNamesLoader.getPackageNames((ClassLoader)classLoader);
        }
        catch (CheckstyleException e) {
            CheckstylePluginException.rethrow(e);
        }
        for (String packageName : packages) {
            String metaFileLocation = packageName.replace('.', '/');
            if (!metaFileLocation.endsWith("/")) {
                metaFileLocation = String.valueOf(metaFileLocation) + "/";
            }
            metaFileLocation = String.valueOf(metaFileLocation) + METADATA_FILENAME;
            potentialMetadataFiles.add(metaFileLocation);
        }
        return potentialMetadataFiles;
    }

    private static ResourceBundle getMetadataI18NBundle(String metadataFile, ClassLoader classLoader) {
        String bundle = metadataFile.substring(0, metadataFile.length() - 4).replace('/', '.');
        try {
            return ResourceBundle.getBundle(bundle, CheckstylePlugin.getPlatformLocale(), classLoader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static void parseMetadata(InputStream metadataStream, ResourceBundle metadataBundle) throws DocumentException, CheckstylePluginException {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new XMLUtil.InternalDtdEntityResolver(PUBLIC2INTERNAL_DTD_MAP));
        Document document = reader.read(metadataStream);
        List groupElements = document.getRootElement().elements("rule-group-metadata");
        for (Element groupEl : groupElements) {
            String groupName = groupEl.attributeValue("name").trim();
            groupName = MetadataFactory.localize(groupName, metadataBundle);
            String groupDesc = groupEl.elementTextTrim("description");
            groupDesc = MetadataFactory.localize(groupDesc, metadataBundle);
            RuleGroupMetadata group = MetadataFactory.getRuleGroupMetadata(groupName);
            if (group == null) {
                boolean hidden = Boolean.valueOf(groupEl.attributeValue("hidden"));
                int priority = 0;
                try {
                    priority = Integer.parseInt(groupEl.attributeValue("priority"));
                }
                catch (Exception e) {
                    CheckstyleLog.log(e);
                    priority = Integer.MAX_VALUE;
                }
                group = new RuleGroupMetadata(groupName, groupDesc, hidden, priority);
                sRuleGroupMetadata.put(groupName, group);
            }
            MetadataFactory.processModules(groupEl, group, metadataBundle);
        }
    }

    private static void processModules(Element groupElement, RuleGroupMetadata groupMetadata, ResourceBundle metadataBundle) throws CheckstylePluginException {
        List moduleElements = groupElement.elements("rule-metadata");
        for (Element moduleEl : moduleElements) {
            String defaultSeverity = moduleEl.attributeValue("default-severity");
            Severity severity = defaultSeverity == null || defaultSeverity.trim().length() == 0 ? MetadataFactory.getDefaultSeverity() : Severity.valueOf(defaultSeverity);
            String name = moduleEl.attributeValue("name").trim();
            name = MetadataFactory.localize(name, metadataBundle);
            String internalName = moduleEl.attributeValue("internal-name").trim();
            String parentName = moduleEl.attributeValue("parent") != null ? moduleEl.attributeValue("parent").trim() : null;
            boolean hidden = Boolean.valueOf(moduleEl.attributeValue("hidden"));
            boolean hasSeverity = !"false".equals(moduleEl.attributeValue("hasSeverity"));
            boolean deletable = !"false".equals(moduleEl.attributeValue("deletable"));
            boolean isSingleton = Boolean.valueOf(moduleEl.attributeValue("singleton"));
            RuleMetadata module = new RuleMetadata(name, internalName, parentName, severity, hidden, hasSeverity, deletable, isSingleton, groupMetadata);
            groupMetadata.getRuleMetadata().add(module);
            sRuleMetadata.put(internalName, module);
            String description = moduleEl.elementTextTrim("description");
            description = MetadataFactory.localize(description, metadataBundle);
            module.setDescription(description);
            MetadataFactory.processProperties(moduleEl, module, metadataBundle);
            for (Element altNameEl : moduleEl.elements("alternative-name")) {
                String alternativeName = altNameEl.attributeValue("internal-name");
                sAlternativeNamesMap.put(alternativeName, module);
                module.addAlternativeName(alternativeName);
            }
            for (Element quickfixEl : moduleEl.elements("quickfix")) {
                String quickfixClassName = quickfixEl.attributeValue("classname");
                module.addQuickfix(quickfixClassName);
            }
            for (Element quickfixEl : moduleEl.elements("message-key")) {
                String messageKey = quickfixEl.attributeValue("key");
                module.addMessageKey(messageKey);
            }
        }
    }

    private static void processProperties(Element moduleElement, RuleMetadata moduleMetadata, ResourceBundle metadataBundle) throws CheckstylePluginException {
        List propertyElements = moduleElement.elements("property-metadata");
        for (Element propertyEl : propertyElements) {
            String overrideDefaultValue;
            ConfigPropertyType type = ConfigPropertyType.valueOf(propertyEl.attributeValue("datatype"));
            String name = propertyEl.attributeValue("name").trim();
            String defaultValue = propertyEl.attributeValue("default-value");
            if (defaultValue != null) {
                defaultValue = defaultValue.trim();
            }
            if ((overrideDefaultValue = propertyEl.attributeValue("override-default-value")) != null) {
                overrideDefaultValue = overrideDefaultValue.trim();
            }
            ConfigPropertyMetadata property = new ConfigPropertyMetadata(type, name, defaultValue, overrideDefaultValue);
            moduleMetadata.getPropertyMetadata().add(property);
            String description = propertyEl.elementTextTrim("description");
            description = MetadataFactory.localize(description, metadataBundle);
            property.setDescription(description);
            Element enumEl = propertyEl.element("enumeration");
            if (enumEl == null) continue;
            String optionProvider = enumEl.attributeValue("option-provider");
            if (optionProvider != null) {
                try {
                    Class<?> providerClass = CheckstylePlugin.getDefault().getAddonExtensionClassLoader().loadClass(optionProvider);
                    if (IOptionProvider.class.isAssignableFrom(providerClass)) {
                        IOptionProvider provider = (IOptionProvider)providerClass.newInstance();
                        property.getPropertyEnumeration().addAll(provider.getOptions());
                    } else if (Enum.class.isAssignableFrom(providerClass)) {
                        EnumSet<Enum> values = EnumSet.allOf(providerClass);
                        for (Enum e : values) {
                            property.getPropertyEnumeration().add(e.name().toLowerCase());
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    CheckstylePluginException.rethrow(e);
                }
            }
            for (Element optionEl : enumEl.elements("property-value-option")) {
                property.getPropertyEnumeration().add(optionEl.attributeValue("value"));
            }
        }
    }

    private static String localize(String localizationCandidate, ResourceBundle metadataBundle) {
        if (metadataBundle != null && localizationCandidate != null && localizationCandidate.startsWith("%")) {
            try {
                return metadataBundle.getString(localizationCandidate.substring(1));
            }
            catch (MissingResourceException e) {
                return localizationCandidate;
            }
        }
        return localizationCandidate;
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        @Override
        public ResourceBundle newBundle(String aBaseName, Locale aLocale, String aFormat, ClassLoader aLoader, boolean aReload) throws IOException {
            String bundleName = this.toBundleName(aBaseName, aLocale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (aReload) {
                URLConnection connection;
                URL url = aLoader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = aLoader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                Reader streamReader = null;
                try {
                    streamReader = new InputStreamReader(stream, "UTF-8");
                    bundle = new PropertyResourceBundle(streamReader);
                }
                finally {
                    streamReader.close();
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

