/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.BuiltInConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationWorkingCopy;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GlobalCheckConfigurationWorkingSet
implements ICheckConfigurationWorkingSet {
    private final List<CheckConfigurationWorkingCopy> mWorkingCopies = new ArrayList<CheckConfigurationWorkingCopy>();
    private final List<CheckConfigurationWorkingCopy> mDeletedConfigurations = new ArrayList<CheckConfigurationWorkingCopy>();
    private CheckConfigurationWorkingCopy mDefaultCheckConfig;
    private ICheckConfiguration mDefaultBuiltInCheckConfig;

    GlobalCheckConfigurationWorkingSet(List<ICheckConfiguration> checkConfigs, ICheckConfiguration defaultConfig, ICheckConfiguration defaultBuiltInCheckConfiguration) {
        this.mDefaultBuiltInCheckConfig = defaultBuiltInCheckConfiguration;
        for (ICheckConfiguration cfg : checkConfigs) {
            CheckConfigurationWorkingCopy workingCopy = new CheckConfigurationWorkingCopy(cfg, this);
            this.mWorkingCopies.add(workingCopy);
            if (cfg != defaultConfig) continue;
            this.mDefaultCheckConfig = workingCopy;
        }
    }

    @Override
    public CheckConfigurationWorkingCopy newWorkingCopy(ICheckConfiguration checkConfig) {
        return new CheckConfigurationWorkingCopy(checkConfig, this);
    }

    @Override
    public CheckConfigurationWorkingCopy newWorkingCopy(IConfigurationType configType) {
        return new CheckConfigurationWorkingCopy(configType, this, true);
    }

    @Override
    public CheckConfigurationWorkingCopy[] getWorkingCopies() {
        return this.mWorkingCopies.toArray(new CheckConfigurationWorkingCopy[this.mWorkingCopies.size()]);
    }

    @Override
    public void addCheckConfiguration(CheckConfigurationWorkingCopy checkConfig) {
        this.mWorkingCopies.add(checkConfig);
    }

    public CheckConfigurationWorkingCopy getDefaultCheckConfig() {
        return this.mDefaultCheckConfig;
    }

    public void setDefaultCheckConfig(CheckConfigurationWorkingCopy defaultCheckConfig) {
        this.mDefaultCheckConfig = defaultCheckConfig;
    }

    @Override
    public boolean removeCheckConfiguration(CheckConfigurationWorkingCopy checkConfig) {
        boolean used = true;
        try {
            used = ProjectConfigurationFactory.isCheckConfigInUse(checkConfig.getSourceCheckConfiguration());
            if (!used) {
                this.mWorkingCopies.remove(checkConfig);
                if (this.mDefaultCheckConfig == checkConfig) {
                    this.mDefaultCheckConfig = null;
                }
                this.mDeletedConfigurations.add(checkConfig);
            }
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log(e);
        }
        return !used;
    }

    @Override
    public void store() throws CheckstylePluginException {
        this.updateProjectConfigurations();
        this.storeToPersistence();
        this.notifyDeletedCheckConfigs();
        CheckConfigurationFactory.refresh();
    }

    @Override
    public boolean isDirty() {
        if (this.mDeletedConfigurations.size() > 0) {
            return true;
        }
        boolean dirty = false;
        for (CheckConfigurationWorkingCopy workingCopy : this.mWorkingCopies) {
            dirty = workingCopy.isDirty();
            if (dirty) break;
        }
        return dirty;
    }

    @Override
    public Collection<IProject> getAffectedProjects() throws CheckstylePluginException {
        HashSet<IProject> projects = new HashSet<IProject>();
        CheckConfigurationWorkingCopy[] workingCopies = this.getWorkingCopies();
        int i = 0;
        while (i < workingCopies.length) {
            if (workingCopies[i].hasConfigurationChanged()) {
                List<IProject> usingProjects = ProjectConfigurationFactory.getProjectsUsingConfig(workingCopies[i]);
                for (IProject proj : usingProjects) {
                    projects.add(proj);
                }
            }
            ++i;
        }
        return projects;
    }

    @Override
    public boolean isNameCollision(CheckConfigurationWorkingCopy configuration) {
        boolean result = false;
        for (CheckConfigurationWorkingCopy tmp : this.mWorkingCopies) {
            if (tmp == configuration || !tmp.getName().equals(configuration.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void updateProjectConfigurations() throws CheckstylePluginException {
        for (CheckConfigurationWorkingCopy checkConfig : this.mWorkingCopies) {
            ICheckConfiguration original = checkConfig.getSourceCheckConfiguration();
            if (original == null || original.getName() == null || checkConfig.getName().equals(original.getName())) continue;
            List<IProject> projects = ProjectConfigurationFactory.getProjectsUsingConfig(checkConfig);
            for (IProject project : projects) {
                IProjectConfiguration projectConfig = ProjectConfigurationFactory.getConfiguration(project);
                ProjectConfigurationWorkingCopy workingCopy = new ProjectConfigurationWorkingCopy(projectConfig);
                List<FileSet> fileSets = workingCopy.getFileSets();
                for (FileSet fileSet : fileSets) {
                    if (!original.equals(fileSet.getCheckConfig())) continue;
                    fileSet.setCheckConfig(checkConfig);
                }
                if (!workingCopy.isDirty()) continue;
                workingCopy.store();
            }
        }
    }

    private void storeToPersistence() throws CheckstylePluginException {
        try {
            IPath configPath = CheckstylePlugin.getDefault().getStateLocation();
            configPath = configPath.append("checkstyle-config.xml");
            File configFile = configPath.toFile();
            CheckConfigurationWorkingCopy defaultConfig = this.mDefaultCheckConfig;
            if (defaultConfig != null && defaultConfig.getName().equals(this.mDefaultBuiltInCheckConfig.getName())) {
                defaultConfig = null;
            }
            Document doc = GlobalCheckConfigurationWorkingSet.createCheckConfigurationsDocument(this.mWorkingCopies, defaultConfig);
            byte[] data = XMLUtil.toByteArray(doc);
            Files.write((byte[])data, (File)configFile);
        }
        catch (IOException e) {
            CheckstylePluginException.rethrow(e, Messages.errorWritingConfigFile);
        }
    }

    private void notifyDeletedCheckConfigs() throws CheckstylePluginException {
        for (ICheckConfiguration iCheckConfiguration : this.mDeletedConfigurations) {
            iCheckConfiguration.getType().notifyCheckConfigRemoved(iCheckConfiguration);
        }
    }

    private static Document createCheckConfigurationsDocument(List<CheckConfigurationWorkingCopy> configurations, ICheckConfiguration defaultConfig) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("checkstyle-configurations");
        root.addAttribute("file-format-version", "5.0.0");
        if (defaultConfig != null) {
            root.addAttribute("default-check-configuration", defaultConfig.getName());
        }
        for (ICheckConfiguration iCheckConfiguration : configurations) {
            if (iCheckConfiguration.getType() instanceof BuiltInConfigurationType || !iCheckConfiguration.isGlobal()) continue;
            Element configEl = root.addElement("check-configuration");
            configEl.addAttribute("name", iCheckConfiguration.getName());
            configEl.addAttribute("location", iCheckConfiguration.getLocation());
            configEl.addAttribute("type", iCheckConfiguration.getType().getInternalName());
            if (iCheckConfiguration.getDescription() != null) {
                configEl.addAttribute("description", iCheckConfiguration.getDescription());
            }
            for (ResolvableProperty resolvableProperty : iCheckConfiguration.getResolvableProperties()) {
                Element propEl = configEl.addElement("property");
                propEl.addAttribute("name", resolvableProperty.getPropertyName());
                propEl.addAttribute("value", resolvableProperty.getValue());
            }
            for (Map.Entry entry : iCheckConfiguration.getAdditionalData().entrySet()) {
                Element addEl = configEl.addElement("additional-data");
                addEl.addAttribute("name", (String)entry.getKey());
                addEl.addAttribute("value", (String)entry.getValue());
            }
        }
        return doc;
    }
}

