/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckConfiguration;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ConfigurationReader;
import net.sf.eclipsecs.core.config.ConfigurationWriter;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;

public class CheckConfigurationWorkingCopy
implements ICheckConfiguration,
Cloneable {
    private final ICheckConfiguration mCheckConfiguration;
    private final ICheckConfigurationWorkingSet mWorkingSet;
    private String mEditedName;
    private String mEditedLocation;
    private String mEditedDescription;
    private List<ResolvableProperty> mProperties = new ArrayList<ResolvableProperty>();
    private Map<String, String> mAdditionalData = new HashMap<String, String>();
    private boolean mHasConfigChanged;

    public CheckConfigurationWorkingCopy(ICheckConfiguration checkConfigToEdit, ICheckConfigurationWorkingSet workingSet) {
        this.mCheckConfiguration = checkConfigToEdit;
        this.mWorkingSet = workingSet;
        this.mAdditionalData.putAll(checkConfigToEdit.getAdditionalData());
        List<ResolvableProperty> props = checkConfigToEdit.getResolvableProperties();
        for (ResolvableProperty prop : props) {
            this.mProperties.add(prop.clone());
        }
    }

    public CheckConfigurationWorkingCopy(IConfigurationType configType, ICheckConfigurationWorkingSet workingSet, boolean global) {
        this.mWorkingSet = workingSet;
        this.mCheckConfiguration = new CheckConfiguration(null, null, null, configType, global, null, null);
    }

    public ICheckConfiguration getSourceCheckConfiguration() {
        return this.mCheckConfiguration;
    }

    public void setName(String name) throws CheckstylePluginException {
        if (name == null || name.trim().length() == 0) {
            throw new CheckstylePluginException(Messages.errorConfigNameEmpty);
        }
        String oldName = this.getName();
        if (!name.equals(oldName)) {
            this.mEditedName = name;
            if (this.mWorkingSet.isNameCollision(this)) {
                this.mEditedName = oldName;
                throw new CheckstylePluginException(NLS.bind((String)Messages.errorConfigNameInUse, (Object)name));
            }
        }
    }

    public void setLocation(String location) throws CheckstylePluginException {
        if (location == null || location.trim().length() == 0) {
            throw new CheckstylePluginException(Messages.errorLocationEmpty);
        }
        String oldLocation = this.getLocation();
        if (!location.equals(oldLocation)) {
            try {
                this.mEditedLocation = location;
                this.getCheckstyleConfiguration();
            }
            catch (Exception e) {
                this.mEditedLocation = oldLocation;
                CheckstylePluginException.rethrow(e, NLS.bind((String)Messages.errorResolveConfigLocation, (Object)location, (Object)e.getLocalizedMessage()));
            }
        }
    }

    public void setDescription(String description) {
        String oldDescription = this.getDescription();
        if (description == null || !description.equals(oldDescription)) {
            this.mEditedDescription = description;
        }
    }

    public boolean isDirty() {
        return !this.equals(this.mCheckConfiguration);
    }

    public boolean hasConfigurationChanged() {
        return this.mHasConfigChanged || !Objects.equals(this.getLocation(), this.mCheckConfiguration.getLocation()) || !Objects.equals(this.getResolvableProperties(), this.mCheckConfiguration.getResolvableProperties()) || !Objects.equals(this.getAdditionalData(), this.mCheckConfiguration.getAdditionalData());
    }

    public List<Module> getModules() throws CheckstylePluginException {
        List<Module> result = null;
        InputSource in = null;
        try {
            in = this.getCheckstyleConfiguration().getCheckConfigFileInputSource();
            result = ConfigurationReader.read(in);
        }
        finally {
            Closeables.closeQuietly((InputStream)in.getByteStream());
        }
        return result;
    }

    public void setModules(List<Module> modules) throws CheckstylePluginException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
                ConfigurationWriter.write(byteOut, modules, this);
                File configFile = URIUtil.toFile((URI)this.getResolvedConfigurationFileURL().toURI());
                Files.write((byte[])byteOut.toByteArray(), (File)configFile);
                Path path = new Path(configFile.toString());
                IFile[] files = CheckstylePlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
                int i = 0;
                while (i < files.length) {
                    try {
                        files[i].refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.mHasConfigChanged = true;
                CheckConfigurationFactory.refresh();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            CheckstylePluginException.rethrow(e);
        }
    }

    @Override
    public String getName() {
        return this.mEditedName != null ? this.mEditedName : this.getSourceCheckConfiguration().getName();
    }

    @Override
    public String getDescription() {
        return this.mEditedDescription != null ? this.mEditedDescription : this.getSourceCheckConfiguration().getDescription();
    }

    @Override
    public String getLocation() {
        return this.mEditedLocation != null ? this.mEditedLocation : this.getSourceCheckConfiguration().getLocation();
    }

    @Override
    public IConfigurationType getType() {
        return this.getSourceCheckConfiguration().getType();
    }

    @Override
    public Map<String, String> getAdditionalData() {
        return this.mAdditionalData;
    }

    @Override
    public List<ResolvableProperty> getResolvableProperties() {
        return this.mProperties;
    }

    @Override
    public URL getResolvedConfigurationFileURL() throws CheckstylePluginException {
        return this.getType().getResolvedConfigurationFileURL(this);
    }

    @Override
    public CheckstyleConfigurationFile getCheckstyleConfiguration() throws CheckstylePluginException {
        return this.getType().getCheckstyleConfiguration(this);
    }

    @Override
    public boolean isEditable() {
        return this.getType().isEditable();
    }

    @Override
    public boolean isConfigurable() {
        return this.getType().isConfigurable(this);
    }

    @Override
    public boolean isGlobal() {
        return this.mCheckConfiguration.isGlobal();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ICheckConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ICheckConfiguration rhs = (ICheckConfiguration)obj;
        return Objects.equals(this.getName(), rhs.getName()) && Objects.equals(this.getLocation(), rhs.getLocation()) && Objects.equals(this.getDescription(), rhs.getDescription()) && Objects.equals(this.getType(), rhs.getType()) && this.isGlobal() == rhs.isGlobal() && Objects.equals(this.getResolvableProperties(), rhs.getResolvableProperties()) && Objects.equals(this.getAdditionalData(), rhs.getAdditionalData());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getLocation(), this.getDescription(), this.getType(), this.isGlobal(), this.getResolvableProperties(), this.getAdditionalData());
    }

    public CheckConfigurationWorkingCopy clone() {
        CheckConfigurationWorkingCopy clone = null;
        try {
            clone = (CheckConfigurationWorkingCopy)super.clone();
            clone.mAdditionalData = new HashMap<String, String>();
            clone.mAdditionalData.putAll(this.mAdditionalData);
            clone.mProperties = new ArrayList<ResolvableProperty>();
            for (ResolvableProperty prop : this.mProperties) {
                clone.mProperties.add(prop.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return clone;
    }
}

