/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import net.sf.eclipsecs.core.config.configtypes.MultiPropertyResolver;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;
import org.xml.sax.InputSource;

public class CheckConfigurationTester {
    private ICheckConfiguration mCheckConfiguration;
    private IProject mContextProject;

    public CheckConfigurationTester(ICheckConfiguration checkConfiguration) {
        this.mCheckConfiguration = checkConfiguration;
    }

    public List<ResolvableProperty> getUnresolvedProperties() throws CheckstylePluginException {
        MissingPropertyCollector collector;
        block8: {
            CheckstyleConfigurationFile configFile = this.mCheckConfiguration.getCheckstyleConfiguration();
            PropertyResolver resolver = configFile.getPropertyResolver();
            if (this.mContextProject != null && resolver instanceof IContextAware) {
                ((IContextAware)resolver).setProjectContext(this.mContextProject);
            }
            collector = new MissingPropertyCollector();
            if (resolver instanceof MultiPropertyResolver) {
                ((MultiPropertyResolver)resolver).addPropertyResolver(collector);
            } else {
                MultiPropertyResolver multiResolver = new MultiPropertyResolver();
                multiResolver.addPropertyResolver(resolver);
                multiResolver.addPropertyResolver(collector);
                resolver = multiResolver;
            }
            InputSource in = null;
            try {
                try {
                    in = configFile.getCheckConfigFileInputSource();
                    ConfigurationLoader.loadConfiguration((InputSource)in, (PropertyResolver)resolver, (boolean)false);
                }
                catch (CheckstyleException e) {
                    CheckstylePluginException.rethrow(e);
                    Closeables.closeQuietly((InputStream)in.getByteStream());
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly((InputStream)in.getByteStream());
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)in.getByteStream());
        }
        return collector.getUnresolvedProperties();
    }

    private static class MissingPropertyCollector
    implements PropertyResolver {
        private static final List<String> IGNORE_PROPS = Arrays.asList("basedir", "project_loc");
        private List<ResolvableProperty> mUnresolvedProperties = new ArrayList<ResolvableProperty>();

        private MissingPropertyCollector() {
        }

        public String resolve(String aName) {
            ResolvableProperty prop;
            if (!IGNORE_PROPS.contains(aName) && !this.mUnresolvedProperties.contains(prop = new ResolvableProperty(aName, null))) {
                this.mUnresolvedProperties.add(prop);
            }
            return "warning";
        }

        public List<ResolvableProperty> getUnresolvedProperties() {
            return this.mUnresolvedProperties;
        }
    }
}

