/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.checkstyle.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static Document getRawXml(String fileName, String code, String unserializedSource) throws ParserConfigurationException {
        Document rawXml = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            rawXml = builder.parse(new InputSource(new StringReader(code)));
        }
        catch (IOException | SAXException ex) {
            Assert.fail((String)(String.valueOf(fileName) + " has invalid xml (" + ex.getMessage() + "): " + unserializedSource));
        }
        return rawXml;
    }

    public static Set<Node> getChildrenElements(Node node) {
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3) {
                result.add(child);
            }
            child = child.getNextSibling();
        }
        return result;
    }

    public static Node findElementByTag(Set<Node> nodes, String tag) {
        Node result = null;
        for (Node child : nodes) {
            if (!tag.equals(child.getNodeName())) continue;
            result = child;
            break;
        }
        return result;
    }

    public static Set<Node> findElementsByTag(Set<Node> nodes, String tag) {
        return nodes.stream().filter(node -> tag.equals(node.getNodeName())).collect(Collectors.toSet());
    }
}

