/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpMultilineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineJavaCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.ModuleReflectionUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;

public final class CheckUtil {
    private static final Set<String> CHECK_PROPERTIES = CheckUtil.getProperties(AbstractCheck.class);
    private static final Set<String> JAVADOC_CHECK_PROPERTIES = CheckUtil.getProperties(AbstractJavadocCheck.class);
    private static final Set<String> FILESET_PROPERTIES = CheckUtil.getProperties(AbstractFileSetCheck.class);
    private static final List<String> UNDOCUMENTED_PROPERTIES = Arrays.asList("Checker.classLoader", "Checker.classloader", "Checker.moduleClassLoader", "Checker.moduleFactory", "TreeWalker.classLoader", "TreeWalker.moduleFactory", "TreeWalker.cacheFile", "TreeWalker.upChild", "SuppressWithNearbyCommentFilter.fileContents", "SuppressionCommentFilter.fileContents");

    private CheckUtil() {
    }

    public static String getSimpleCheckstyleModuleName(Class<?> module) {
        return module.getSimpleName().replaceAll("Check$", "");
    }

    public static Set<Class<?>> getCheckstyleModules() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ModuleReflectionUtil.getCheckstyleModules((Collection)PackageNamesLoader.getPackageNames((ClassLoader)loader), (ClassLoader)loader);
    }

    public static Set<String> getPackages(Set<Class<?>> modules) {
        HashSet<String> result = new HashSet<String>();
        for (Class<?> module : modules) {
            result.add(module.getPackage().getName());
        }
        return result;
    }

    public static Set<Class<?>> getModulesInPackage(Set<Class<?>> modules, String packge) {
        HashSet result = new HashSet();
        for (Class<?> module : modules) {
            if (!module.getPackage().getName().endsWith(packge)) continue;
            result.add(module);
        }
        return result;
    }

    public static Set<String> getCheckProperties(Class<?> clss) throws Exception {
        AbstractCheck check;
        Object instance;
        Set<String> properties = CheckUtil.getProperties(clss);
        if (AbstractJavadocCheck.class.isAssignableFrom(clss)) {
            properties.removeAll(JAVADOC_CHECK_PROPERTIES);
            properties.add("violateExecutionOnNonTightHtml");
        } else if (AbstractCheck.class.isAssignableFrom(clss)) {
            properties.removeAll(CHECK_PROPERTIES);
        } else if (AbstractFileSetCheck.class.isAssignableFrom(clss)) {
            properties.removeAll(FILESET_PROPERTIES);
            properties.add("fileExtensions");
        } else if (Checker.class.equals(clss)) {
            properties.remove("severity");
        }
        for (String prop : new HashSet<String>(properties)) {
            if (!UNDOCUMENTED_PROPERTIES.contains(String.valueOf(clss.getSimpleName()) + "." + prop)) continue;
            properties.remove(prop);
        }
        if (AbstractCheck.class.isAssignableFrom(clss)) {
            instance = clss.newInstance();
            check = (AbstractCheck)instance;
            int[] acceptableTokens = check.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            int[] defaultTokens = check.getDefaultTokens();
            Arrays.sort(defaultTokens);
            int[] requiredTokens = check.getRequiredTokens();
            Arrays.sort(requiredTokens);
            if (!Arrays.equals(acceptableTokens, defaultTokens) || !Arrays.equals(acceptableTokens, requiredTokens)) {
                properties.add("tokens");
            }
        }
        if (AbstractJavadocCheck.class.isAssignableFrom(clss)) {
            instance = clss.newInstance();
            check = (AbstractJavadocCheck)instance;
            int[] acceptableJavadocTokens = check.getAcceptableJavadocTokens();
            Arrays.sort(acceptableJavadocTokens);
            int[] defaultJavadocTokens = check.getDefaultJavadocTokens();
            Arrays.sort(defaultJavadocTokens);
            int[] requiredJavadocTokens = check.getRequiredJavadocTokens();
            Arrays.sort(requiredJavadocTokens);
            if (!Arrays.equals(acceptableJavadocTokens, defaultJavadocTokens) || !Arrays.equals(acceptableJavadocTokens, requiredJavadocTokens)) {
                properties.add("javadocTokens");
            }
        }
        return properties;
    }

    private static Set<String> getProperties(Class<?> clss) {
        PropertyDescriptor[] map;
        TreeSet<String> result = new TreeSet<String>();
        PropertyDescriptor[] propertyDescriptorArray = map = PropertyUtils.getPropertyDescriptors(clss);
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor p = propertyDescriptorArray[n2];
            if (p.getWriteMethod() != null) {
                result.add(p.getName());
            }
            ++n2;
        }
        return result;
    }

    public static Set<Field> getCheckMessages(Class<?> module) throws ClassNotFoundException {
        Field[] fields;
        HashSet<Field> checkstyleMessages = new HashSet<Field>();
        Field[] fieldArray = fields = module.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().startsWith("MSG_")) {
                checkstyleMessages.add(field);
            }
            ++n2;
        }
        Class<?> superModule = module.getSuperclass();
        if (superModule != null) {
            checkstyleMessages.addAll(CheckUtil.getCheckMessages(superModule));
        }
        if (module == RegexpMultilineCheck.class) {
            checkstyleMessages.addAll(CheckUtil.getCheckMessages(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.MultilineDetector")));
        } else if (module == RegexpSinglelineCheck.class || module == RegexpSinglelineJavaCheck.class) {
            checkstyleMessages.addAll(CheckUtil.getCheckMessages(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.SinglelineDetector")));
        }
        return checkstyleMessages;
    }

    public static String getTokenText(int[] tokens, int ... subtractions) {
        String tokenText = null;
        if (subtractions.length == 0 && Arrays.equals(tokens, TokenUtil.getAllTokenIds())) {
            tokenText = "TokenTypes";
        } else {
            Arrays.sort(subtractions);
            tokenText = Arrays.stream(tokens).filter(token -> Arrays.binarySearch(subtractions, token) < 0).mapToObj(TokenUtil::getTokenName).collect(Collectors.joining(","));
        }
        return tokenText.length() == 0 ? null : tokenText;
    }

    public static String getJavadocTokenText(int[] tokens, int ... subtractions) {
        Arrays.sort(subtractions);
        String tokenText = Arrays.stream(tokens).filter(token -> Arrays.binarySearch(subtractions, token) < 0).mapToObj(JavadocUtil::getTokenName).collect(Collectors.joining(","));
        tokenText = tokenText.length() == 0 ? "empty" : String.valueOf(tokenText) + ".";
        return tokenText;
    }
}

