/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.utils.ModuleReflectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.sf.eclipsecs.checkstyle.utils.CheckUtil;
import net.sf.eclipsecs.checkstyle.utils.XmlUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChecksTest {
    @Test
    public void testMetadataFiles() throws Exception {
        Set<Class<?>> modules = CheckUtil.getCheckstyleModules();
        Set<String> packages = CheckUtil.getPackages(modules);
        Assert.assertTrue((String)"no modules", (modules.size() > 0 ? 1 : 0) != 0);
        for (String p : packages) {
            Assert.assertTrue((String)("folder " + p + " must exist in eclipsecs"), (boolean)new File(ChecksTest.getEclipseCsPath(p, "")).exists());
            Set<Class<?>> packgeModules = CheckUtil.getModulesInPackage(modules, p);
            ChecksTest.validateEclipseCsMetaXmlFile(new File(ChecksTest.getEclipseCsPath(p, "/checkstyle-metadata.xml")), p, new HashSet(packgeModules));
            ChecksTest.validateEclipseCsMetaPropFile(new File(ChecksTest.getEclipseCsPath(p, "/checkstyle-metadata.properties")), p, new HashSet(packgeModules));
        }
    }

    private static void validateEclipseCsMetaXmlFile(File file, String packge, Set<Class<?>> packgeModules) throws Exception {
        Assert.assertTrue((String)("'checkstyle-metadata.xml' must exist in eclipsecs in inside " + packge), (boolean)file.exists());
        String input = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        Document document = XmlUtil.getRawXml(file.getAbsolutePath(), input, input);
        NodeList ruleGroups = document.getElementsByTagName("rule-group-metadata");
        Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml must contain only one rule group"), (long)1L, (long)ruleGroups.getLength());
        int position = 0;
        while (position < ruleGroups.getLength()) {
            Node ruleGroup = ruleGroups.item(position);
            Set<Node> children = XmlUtil.getChildrenElements(ruleGroup);
            ChecksTest.validateEclipseCsMetaXmlFileRules(packge, packgeModules, children);
            ++position;
        }
        for (Class<?> module : packgeModules) {
            Assert.fail((String)("Module not found in " + packge + " checkstyle-metadata.xml: " + module.getCanonicalName()));
        }
    }

    private static void validateEclipseCsMetaXmlFileRules(String packge, Set<Class<?>> packgeModules, Set<Node> rules) throws Exception {
        for (Node rule : rules) {
            NamedNodeMap attributes = rule.getAttributes();
            Node internalNameNode = attributes.getNamedItem("internal-name");
            Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml must contain an internal name"), (Object)internalNameNode);
            String internalName = internalNameNode.getTextContent();
            String classpath = String.valueOf(packge) + "." + internalName;
            Class<?> module = ChecksTest.findModule(packgeModules, classpath);
            packgeModules.remove(module);
            Assert.assertNotNull((String)("Unknown class found in " + packge + " checkstyle-metadata.xml: " + internalName), module);
            Node nameAttribute = attributes.getNamedItem("name");
            Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a name for " + internalName), (Object)nameAttribute);
            Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a valid name for " + internalName), (Object)("%" + internalName + ".name"), (Object)nameAttribute.getTextContent());
            Node parentAttribute = attributes.getNamedItem("parent");
            String parentValue = ModuleReflectionUtil.isCheckstyleTreeWalkerCheck(module) || ModuleReflectionUtil.isTreeWalkerFilterModule(module) ? "TreeWalker" : (ModuleReflectionUtil.isRootModule(module) ? "Root" : "Checker");
            Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a parent for " + internalName), (Object)parentAttribute);
            Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a valid parent for " + internalName), (Object)parentValue, (Object)parentAttribute.getTextContent());
            Set<Node> children = XmlUtil.getChildrenElements(rule);
            ChecksTest.validateEclipseCsMetaXmlFileRule(packge, module, children);
        }
    }

    private static void validateEclipseCsMetaXmlFileRule(String packge, Class<?> module, Set<Node> children) throws Exception {
        String moduleName = CheckUtil.getSimpleCheckstyleModuleName(module);
        String quickfixClass = ChecksTest.getQuickfixClass(module);
        Set<String> properties = CheckUtil.getCheckProperties(module);
        Set<Field> fieldMessages = CheckUtil.getCheckMessages(module);
        TreeSet<String> messages = new TreeSet<String>();
        for (Field fieldMessage : fieldMessages) {
            if (!fieldMessage.isAccessible()) {
                fieldMessage.setAccessible(true);
            }
            messages.add(fieldMessage.get(null).toString());
        }
        for (Node child : children) {
            NamedNodeMap attributes = child.getAttributes();
            switch (child.getNodeName()) {
                case "alternative-name": {
                    Node internalNameNode = attributes.getNamedItem("internal-name");
                    Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml must contain an internal name for " + moduleName), (Object)internalNameNode);
                    String internalName = internalNameNode.getTextContent();
                    Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a valid internal-name for " + moduleName), (Object)module.getName(), (Object)internalName);
                    break;
                }
                case "description": {
                    Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a valid description for " + moduleName), (Object)("%" + moduleName + ".desc"), (Object)child.getTextContent());
                    break;
                }
                case "property-metadata": {
                    String propertyName = attributes.getNamedItem("name").getTextContent();
                    Assert.assertTrue((String)(String.valueOf(packge) + " checkstyle-metadata.xml has an unknown parameter for " + moduleName + ": " + propertyName), (boolean)properties.remove(propertyName));
                    ChecksTest.validateEclipseCsMetaXmlFileRuleProperty(packge, module, moduleName, propertyName, child);
                    break;
                }
                case "message-key": {
                    String key = attributes.getNamedItem("key").getTextContent();
                    Assert.assertTrue((String)(String.valueOf(packge) + " checkstyle-metadata.xml has an unknown message for " + moduleName + ": " + key), (boolean)messages.remove(key));
                    break;
                }
                case "quickfix": {
                    String className = attributes.getNamedItem("classname").getTextContent();
                    Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml should have a valid quickfix class for " + moduleName), (Object)quickfixClass, (Object)className);
                    quickfixClass = null;
                    break;
                }
                default: {
                    Assert.fail((String)(String.valueOf(packge) + " checkstyle-metadata.xml unknown node for " + moduleName + ": " + child.getNodeName()));
                }
            }
        }
        Assert.assertNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml missing quickfix for " + moduleName + ": " + quickfixClass), (Object)quickfixClass);
        for (String property : properties) {
            Assert.fail((String)(String.valueOf(packge) + " checkstyle-metadata.xml missing parameter for " + moduleName + ": " + property));
        }
        for (String message : messages) {
            Assert.fail((String)(String.valueOf(packge) + " checkstyle-metadata.xml missing message for " + moduleName + ": " + message));
        }
    }

    private static void validateEclipseCsMetaXmlFileRuleProperty(String packge, Class<?> module, String moduleName, String propertyName, Node propertyNode) throws Exception {
        Node firstChild = propertyNode.getFirstChild().getNextSibling();
        Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires atleast one child for " + moduleName + ", " + propertyName), (Object)firstChild);
        Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml should have a description for the " + "first child of " + moduleName + ", " + propertyName), (Object)"description", (Object)firstChild.getNodeName());
        Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a valid description for " + moduleName + ", " + propertyName), (Object)("%" + moduleName + "." + propertyName), (Object)firstChild.getTextContent());
        if ("tokens".equals(propertyName)) {
            ChecksTest.validateEclipseCsMetaXmlFileRuleTokens(packge, module, moduleName, propertyName, propertyNode);
        } else if ("javadocTokens".equals(propertyName)) {
            ChecksTest.validateEclipseCsMetaXmlFileRuleJavadocTokens();
        }
    }

    private static void validateEclipseCsMetaXmlFileRuleTokens(String packge, Class<?> module, String moduleName, String propertyName, Node propertyNode) throws Exception {
        block12: {
            Node enumerationChild;
            String acceptableText;
            block11: {
                AbstractCheck check = (AbstractCheck)module.newInstance();
                String defaultText = CheckUtil.getTokenText(check.getDefaultTokens(), check.getRequiredTokens());
                acceptableText = CheckUtil.getTokenText(check.getAcceptableTokens(), check.getRequiredTokens());
                Node defaultValueNode = propertyNode.getAttributes().getNamedItem("default-value");
                if (defaultText == null) {
                    Assert.assertNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml should not have a default value for " + moduleName + ", " + propertyName), (Object)defaultValueNode);
                } else {
                    Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a default value for " + moduleName + ", " + propertyName), (Object)defaultValueNode);
                    Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires a valid default value for " + moduleName + ", " + propertyName), (Object)defaultText, (Object)defaultValueNode.getTextContent());
                }
                enumerationChild = propertyNode.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
                if (acceptableText != null) break block11;
                Assert.assertNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml should not have an enumeration child for " + moduleName + ", " + propertyName), (Object)enumerationChild);
                break block12;
            }
            Assert.assertNotNull((String)(String.valueOf(packge) + " checkstyle-metadata.xml requires an enumeration child for " + moduleName + ", " + propertyName), (Object)enumerationChild);
            Assert.assertEquals((String)(String.valueOf(packge) + " checkstyle-metadata.xml should have a enumeration for the " + " child of " + moduleName + ", " + propertyName), (Object)"enumeration", (Object)enumerationChild.getNodeName());
            if ("TokenTypes".equals(acceptableText)) break block12;
            HashSet options = new HashSet();
            Collections.addAll(options, acceptableText.split(","));
            for (Node child : XmlUtil.getChildrenElements(enumerationChild)) {
                switch (child.getNodeName()) {
                    case "property-value-option": {
                        String value = child.getAttributes().getNamedItem("value").getTextContent();
                        Assert.assertTrue((String)(String.valueOf(packge) + " checkstyle-metadata.xml has an unknown acceptable token for " + moduleName + ", " + propertyName + ": " + value), (boolean)options.remove(value));
                        break;
                    }
                    default: {
                        Assert.fail((String)(String.valueOf(packge) + " checkstyle-metadata.xml unknown node for " + moduleName + ", " + propertyName + ": " + child.getNodeName()));
                    }
                }
            }
            for (String option : options) {
                Assert.fail((String)(String.valueOf(packge) + " checkstyle-metadata.xml missing acceptable token for " + moduleName + ", " + propertyName + ": " + option));
            }
        }
    }

    private static void validateEclipseCsMetaXmlFileRuleJavadocTokens() {
    }

    private static String getQuickfixClass(Class<?> module) throws IOException {
        String clss = "net.sf.eclipsecs.ui.quickfixes" + module.getPackage().getName().replace("com.puppycrawl.tools.checkstyle.checks", "") + "." + CheckUtil.getSimpleCheckstyleModuleName(module) + "Quickfix";
        String location = ChecksTest.getEclipseQuickfixPath(clss);
        if (new File(location).exists()) {
            return clss;
        }
        clss = "net.sf.eclipsecs.ui.quickfixes.misc." + CheckUtil.getSimpleCheckstyleModuleName(module) + "Quickfix";
        location = ChecksTest.getEclipseQuickfixPath(clss);
        if (new File(location).exists()) {
            return clss;
        }
        return null;
    }

    private static void validateEclipseCsMetaPropFile(File file, String packge, Set<Class<?>> packgeModules) throws Exception {
        Assert.assertTrue((String)("'checkstyle-metadata.properties' must exist in eclipsecs in inside " + packge), (boolean)file.exists());
        Properties prop = new Properties();
        prop.load(new FileInputStream(file));
        HashSet<Object> properties = new HashSet<Object>(Collections.list(prop.keys()));
        for (Class<?> clazz : packgeModules) {
            String moduleName = CheckUtil.getSimpleCheckstyleModuleName(clazz);
            Assert.assertTrue((String)(String.valueOf(moduleName) + " requires a name in eclipsecs properties " + packge), (boolean)properties.remove(String.valueOf(moduleName) + ".name"));
            Assert.assertTrue((String)(String.valueOf(moduleName) + " requires a desc in eclipsecs properties " + packge), (boolean)properties.remove(String.valueOf(moduleName) + ".desc"));
            Set<String> moduleProperties = CheckUtil.getCheckProperties(clazz);
            for (String moduleProperty : moduleProperties) {
                Assert.assertTrue((String)(String.valueOf(moduleName) + " requires the property " + moduleProperty + " in eclipsecs properties " + packge), (boolean)properties.remove(String.valueOf(moduleName) + "." + moduleProperty));
            }
        }
        for (Class<Object> clazz : properties) {
            if (((Object)clazz).toString().endsWith(".group")) continue;
            Assert.fail((String)("Unknown property found in eclipsecs properties " + packge + ": " + clazz));
        }
    }

    private static Class<?> findModule(Set<Class<?>> modules, String classPath) {
        Class<?> result = null;
        for (Class<?> module : modules) {
            String moduleName = module.getCanonicalName();
            if (!moduleName.equals(classPath) && !moduleName.equals(String.valueOf(classPath) + "Check")) continue;
            result = module;
            break;
        }
        return result;
    }

    private static String getEclipseCsPath(String packageName, String fileName) throws IOException {
        return new File("../net.sf.eclipsecs.checkstyle/metadata/" + packageName.replace(".", "/") + fileName).getCanonicalPath();
    }

    private static String getEclipseQuickfixPath(String classpath) throws IOException {
        return new File("../net.sf.eclipsecs.ui/src/" + classpath.replace(".", "/") + ".java").getCanonicalPath();
    }
}

